#!/usr/bin/python

from __future__ import print_function
import smbus
import sys
import time
import getopt

ADDRESS = ''	# I2C-address as integer [8-31]
PROTOCOL = ''	# protocol as integer [1-15]
SYSCODE = ''	# system-code as integer-bitmask
VALUE = ''		# value as integer-bitmask

def usage():
  print("\n==============================")
  print("Horter I2HFS I2C-433 MHz Modul")
  print("==============================\n")
  print('Usage: '+sys.argv[0]+' -a [ADDRESS] -p [PROTOCOL] -s [SYSCODE] -v [VALUE]')
  print("\r")
  print("-h\t--help\t\t\tshow Usage")
  print("-a\t--address=\tM\tI2C-ADDRESS as Integer")
  print("-p\t--protocol=\tM\tProtocol as Integer [1-15]")
  print("-s\t--syscode=\tM\tSystemcode as Integer-Bitmask [0-31]")
  print("-v\t--value=\tM\tValue as Integer-Bitmask [0-255]\n")

def protocol_01():  
  # create I2C-instance
  I2HFS = smbus.SMBus(2)
  
  # write protocol ############################################################
  REGISTER = 0x02
  DATA = [ PROTOCOL, 0x01 ]
  I2HFS.write_i2c_block_data(ADDRESS, REGISTER, DATA)

  time.sleep(0.05)

  # write systemcode ##########################################################
  REGISTER = 0x00
  DATA = [ 15, 15, 15, 15, 15 ]
  
  V_STRING = bin(SYSCODE)	# e.g 0b1010
  V = V_STRING[2:]			# e.g 1010

  i = len(V) - 1
  n = 0
  while i >= 0:
    BIT = V[i:][:1]
    if BIT == "1":
      DATA[n] = 0

    i = i - 1
    n = n + 1
	
  print ("\nSYSTEMCODE=\t",DATA)

  I2HFS.write_i2c_block_data(ADDRESS, REGISTER, DATA)

  time.sleep(0.05)

  # write value ###############################################################
  DATA = [ 1, 2, 3, 4, 5, 6, 7, 8 ]

  V_STRING = bin(VALUE)		# e.g. 0b1010
  V = V_STRING[2:]			# e.g. 1010

  i = len(V) - 1
  n = 0
  while i >= 0:
    BIT = V[i:][:1]
    if BIT == "1":
      DATA[n] = n + 1 + 128

    i = i - 1
    n = n + 1
	
  print ("VALUE=\t\t",DATA,"\n")

  # check if module is sending
  REGISTER = 0x02
  STATUS = I2HFS.read_i2c_block_data(ADDRESS, REGISTER, 8)
  while STATUS[2] != 15:	# also 0xAC = 172 = ACtive
    time.sleep(0.01)
    STATUS = I2HFS.read_i2c_block_data(ADDRESS, REGISTER, 8)

  time.sleep(0.05)
  
  # write value only if module is not sending
  if STATUS[2] == 15:		# also 0x0F = 15 = OFF
    REGISTER = 0x01
    I2HFS.write_i2c_block_data(ADDRESS, REGISTER, DATA)
  
def main(argv):

  global ADDRESS
  global PROTOCOL
  global SYSCODE
  global VALUE
  
  try:
    opts, args = getopt.getopt(argv,"ha:p:s:v:",["address=","protocol=","syscode=","value="])
  except getopt.GetoptError:
    usage()
    sys.exit(2)
  for opt, arg in opts:
    if opt == '-h':
      usage()
      sys.exit()
    elif opt in ("-a", "--address"):
      ADDRESS = int(arg)
    elif opt in ("-p", "--protocol"):
      PROTOCOL = int(arg)
    elif opt in ("-s", "--syscode"):
      SYSCODE = int(arg)
    elif opt in ("-v", "--value"):
      VALUE = int(arg)

  if ADDRESS == '':
    usage()
    sys.exit(2)

  if VALUE == '':
    usage()
    sys.exit(2)
	
  if SYSCODE == '':
    usage()
    sys.exit(2)
	
  if PROTOCOL == '':
    usage()
    sys.exit(2)
  elif PROTOCOL == 1:
    protocol_01()
  else:
    print("\nProtocol",PROTOCOL,"not available!\n")

if __name__ == "__main__":
  main(sys.argv[1:])
