/* 
 ==============================================
 Test I2C-Output - Lauflicht
 ==============================================
 */

#include <Wire.h>
#define I2C_OUT_ADDR 64 >> 1 // I2C-Addresse als 7 Bit

byte WERT=0;
byte OUT_INV=0;


void setup() {
  Serial.begin(9600);       // Serielle Schnittstelle konfigurieren
  Wire.begin(I2C_OUT_ADDR); // I2C-Pins definieren
}

void loop() { 

  if (WERT==0) {            // Wenn Wert=0 Bit 0 setzen
    WERT = 1; 
  }
  else {
    WERT = WERT <<1;       // ein Bit nach links schieben
  }

  OUT_INV = 255-WERT;      // in invertierte Ausgabe wandlen 

  Serial.println(WERT);    // Wert auf "Seriel Monitor" ausgeben

  Wire.beginTransmission(I2C_OUT_ADDR);  // Start Übertragung zum PCF8574
  Wire.write(OUT_INV);                   // Wert schreiben
  Wire.endTransmission();                // Ende

  delay(100);
}

