VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form Form1 
   Caption         =   "I2C-Modem DEMO Visual Basic 6.0"
   ClientHeight    =   8160
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7080
   LinkTopic       =   "Form1"
   ScaleHeight     =   8160
   ScaleWidth      =   7080
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.Frame Frame6 
      Caption         =   "Schnittstelle"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   120
      TabIndex        =   35
      Top             =   240
      Width           =   3735
      Begin VB.CommandButton Button_OPEN 
         BackColor       =   &H008080FF&
         Caption         =   "COM ffnen"
         Height          =   435
         Left            =   120
         TabIndex        =   37
         Top             =   360
         Width           =   1815
      End
      Begin VB.ComboBox Combo_ComPort 
         Height          =   315
         ItemData        =   "Form1.frx":0000
         Left            =   2040
         List            =   "Form1.frx":0010
         TabIndex        =   36
         Text            =   "COM1"
         Top             =   360
         Width           =   1455
      End
      Begin VB.Label Label_COM 
         Alignment       =   2  'Zentriert
         BackColor       =   &H008080FF&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "getrennt"
         Height          =   300
         Left            =   120
         TabIndex        =   38
         Top             =   840
         Width           =   3375
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   "Allgemein"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2775
      Left            =   120
      TabIndex        =   26
      Top             =   1560
      Width           =   3735
      Begin VB.CommandButton Button_VERSION 
         Caption         =   "VERSION"
         Enabled         =   0   'False
         Height          =   435
         Left            =   120
         TabIndex        =   39
         Top             =   960
         Width           =   1815
      End
      Begin VB.CommandButton Button_IDENT 
         Caption         =   "IDENT"
         Enabled         =   0   'False
         Height          =   435
         Left            =   120
         TabIndex        =   30
         Top             =   360
         Width           =   1815
      End
      Begin VB.CommandButton Button_SPEED 
         Caption         =   "SPEED"
         Height          =   435
         Left            =   120
         TabIndex        =   29
         Top             =   2160
         Width           =   1755
      End
      Begin VB.ComboBox Combo_SPEED 
         Height          =   315
         ItemData        =   "Form1.frx":002C
         Left            =   2040
         List            =   "Form1.frx":0045
         TabIndex        =   28
         Text            =   "0 =  43  KHz"
         Top             =   2160
         Width           =   1515
      End
      Begin VB.CommandButton Button_STATUS 
         Caption         =   "STATUS"
         Enabled         =   0   'False
         Height          =   435
         Left            =   120
         TabIndex        =   27
         Top             =   1560
         Width           =   1815
      End
      Begin VB.Label Label_VERSION 
         Alignment       =   2  'Zentriert
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "Version x.y"
         Height          =   300
         Left            =   2040
         TabIndex        =   40
         Top             =   960
         Width           =   1455
      End
      Begin VB.Label Label_SDA 
         Alignment       =   2  'Zentriert
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "SDA"
         Height          =   300
         Left            =   2040
         TabIndex        =   34
         Top             =   1560
         Width           =   495
      End
      Begin VB.Label Label_SCL 
         Alignment       =   2  'Zentriert
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "SCL"
         Height          =   300
         Left            =   2520
         TabIndex        =   33
         Top             =   1560
         Width           =   495
      End
      Begin VB.Label Label_INT 
         Alignment       =   2  'Zentriert
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "INT"
         Height          =   300
         Left            =   3000
         TabIndex        =   32
         Top             =   1560
         Width           =   495
      End
      Begin VB.Label Label_IDENT 
         Alignment       =   2  'Zentriert
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "Ident?"
         Height          =   300
         Left            =   2040
         TabIndex        =   31
         Top             =   360
         Width           =   1455
      End
   End
   Begin VB.Frame Frame4 
      Caption         =   "Status I2C-Modem"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3375
      Left            =   4080
      TabIndex        =   16
      Top             =   240
      Width           =   2895
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Daten Time out"
         Height          =   375
         Index           =   6
         Left            =   120
         TabIndex        =   24
         Top             =   2880
         Width           =   2655
      End
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Kommando Time out"
         Height          =   375
         Index           =   5
         Left            =   120
         TabIndex        =   23
         Top             =   2520
         Width           =   2655
      End
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Kommando falsch"
         Height          =   375
         Index           =   4
         Left            =   120
         TabIndex        =   22
         Top             =   2160
         Width           =   2655
      End
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Empfangsbuffer nicht leer"
         Height          =   375
         Index           =   3
         Left            =   120
         TabIndex        =   21
         Top             =   1800
         Width           =   2655
      End
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Fehler I2C Daten"
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   20
         Top             =   1440
         Width           =   1935
      End
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Fehler I2C Adresse"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   19
         Top             =   1080
         Width           =   1935
      End
      Begin VB.CheckBox Check_STATUS 
         Caption         =   "Fehler SCL Leitung"
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   18
         Top             =   720
         Width           =   1935
      End
      Begin VB.Label Label_STATUS_BYTES 
         Caption         =   "? Bytes empfangen"
         Height          =   255
         Left            =   1200
         TabIndex        =   25
         Top             =   360
         Width           =   1575
      End
      Begin VB.Label Label_STATUS_MODEM 
         Alignment       =   2  'Zentriert
         BackColor       =   &H0080FF80&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "?"
         Height          =   300
         Left            =   120
         TabIndex        =   17
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Temperatursensor"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   120
      TabIndex        =   11
      Top             =   6960
      Width           =   4335
      Begin VB.TextBox Text_LM75 
         Height          =   285
         Left            =   3240
         TabIndex        =   15
         Text            =   "0"
         Top             =   480
         Width           =   855
      End
      Begin VB.ComboBox Combo_LM75_ADR 
         Height          =   315
         ItemData        =   "Form1.frx":00AB
         Left            =   1920
         List            =   "Form1.frx":00CF
         TabIndex        =   13
         Text            =   "145"
         ToolTipText     =   "Hier die PCF-Adresse einstellen"
         Top             =   480
         Width           =   1095
      End
      Begin VB.CommandButton Command_LM75 
         Caption         =   "Temperatur lesen"
         Enabled         =   0   'False
         Height          =   435
         Left            =   120
         TabIndex        =   12
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label4 
         Caption         =   "Adresse                 Wert"
         Height          =   255
         Left            =   1920
         TabIndex        =   14
         Top             =   240
         Width           =   1815
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Ausgabekarte"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   120
      TabIndex        =   4
      Top             =   4560
      Width           =   5295
      Begin VB.ComboBox Combo_AUSGABE_ADR 
         Height          =   315
         ItemData        =   "Form1.frx":00FB
         Left            =   1920
         List            =   "Form1.frx":0147
         TabIndex        =   42
         Text            =   "64"
         ToolTipText     =   "Hier die PCF-Adresse einstellen"
         Top             =   480
         Width           =   1095
      End
      Begin VB.CheckBox Check_A_INVERS 
         Caption         =   "invers"
         Height          =   255
         Left            =   4320
         TabIndex        =   8
         Top             =   480
         Width           =   855
      End
      Begin VB.TextBox Text_AUSGABE_WERT 
         Height          =   285
         Left            =   3240
         TabIndex        =   6
         Text            =   "0"
         Top             =   480
         Width           =   855
      End
      Begin VB.CommandButton Button_SCHREIBEN 
         Caption         =   "SCHREIBEN"
         Enabled         =   0   'False
         Height          =   435
         Left            =   120
         TabIndex        =   5
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label1 
         Caption         =   "Adresse                 Wert"
         Height          =   255
         Left            =   1920
         TabIndex        =   7
         Top             =   240
         Width           =   1815
      End
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   50
      Left            =   4200
      Top             =   3840
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   4800
      Top             =   3840
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      InputMode       =   1
   End
   Begin VB.Frame Frame1 
      Caption         =   "Eingabekarte"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   120
      TabIndex        =   0
      Top             =   5760
      Width           =   6795
      Begin VB.ComboBox Combo_EINGABE_ADR 
         Height          =   315
         ItemData        =   "Form1.frx":0193
         Left            =   1920
         List            =   "Form1.frx":01DF
         TabIndex        =   41
         Text            =   "65"
         ToolTipText     =   "Hier die PCF-Adresse einstellen"
         Top             =   480
         Width           =   1095
      End
      Begin VB.CheckBox Check_E_INVERS 
         Caption         =   "invers"
         Height          =   255
         Left            =   4320
         TabIndex        =   9
         Top             =   480
         Width           =   855
      End
      Begin VB.TextBox Text_EINGABE_WERT 
         Height          =   285
         Left            =   3240
         TabIndex        =   3
         Text            =   "0"
         Top             =   480
         Width           =   855
      End
      Begin VB.CommandButton Button_LESEN 
         Caption         =   "LESEN"
         Enabled         =   0   'False
         Height          =   435
         Left            =   120
         TabIndex        =   2
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label_AUTO_INT 
         Alignment       =   2  'Zentriert
         BackColor       =   &H80000005&
         BorderStyle     =   1  'Fest Einfach
         Caption         =   "Autom. INT"
         Height          =   300
         Left            =   5400
         TabIndex        =   43
         Top             =   480
         Width           =   1215
      End
      Begin VB.Label Label2 
         Caption         =   "Adresse                 Wert"
         Height          =   255
         Left            =   1920
         TabIndex        =   1
         Top             =   240
         Width           =   2175
      End
   End
   Begin VB.Label Label_HORTER_DE 
      Caption         =   "http://www.horter.de"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   11.25
         Charset         =   0
         Weight          =   700
         Underline       =   -1  'True
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00800000&
      Height          =   375
      Left            =   4680
      TabIndex        =   10
      Top             =   7560
      Width           =   2295
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit      ' Explizite Variablendeklaration erzwingen.

Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long


Private Sub Form_Load()
'50ms als Zeitverzug bis Antwort vom Modem gelesen wird
Timer1.Interval = 50

'Combo_SPEED auf Index 0 Stellen
Combo_SPEED.ListIndex = 0

End Sub

Private Sub Form_Unload(Cancel As Integer)
'COM-Port schlieen falls geffnet wurde

If MSComm1.PortOpen = True Then
    MSComm1.PortOpen = False        'COM zu
End If

End Sub

Private Sub Button_OPEN_Click()
Dim Mldg, Fehler
Dim CNr

On Error GoTo Fehlerbehandlung

CNr = Right$(Combo_ComPort.Text, 1)

If MSComm1.PortOpen = False Then
    With MSComm1
        .CommPort = CNr
        .Settings = "19200,n,8,1"
        'Schnittstelle fpr Binrdaten ffnen
        .InputMode = comInputModeBinary
        'kein CommEvent auslsen bei lesen / schreiben
        .RThreshold = 0
        .SThreshold = 0
        'Port ffnen
        .PortOpen = True
    End With
    Button_OPEN.Caption = "COM schlieen"
    Label_COM.Caption = "verbunden"
    Label_COM.BackColor = hgn
    
    'Buttons freigeben
    Button_IDENT.Enabled = True
    Button_VERSION.Enabled = True
    Button_STATUS.Enabled = True
    Button_SPEED.Enabled = True
    Button_LESEN.Enabled = True
    Button_SCHREIBEN.Enabled = True
    Command_LM75.Enabled = True
        
Else
    MSComm1.PortOpen = False        'COM zu
    Button_OPEN.Caption = "COM ffnen"
    Label_COM.Caption = "getrennt"
    Label_COM.BackColor = hrt

    'Buttons sperren
    Button_IDENT.Enabled = False
    Button_VERSION.Enabled = False
    Button_STATUS.Enabled = False
    Button_SPEED.Enabled = False
    Button_LESEN.Enabled = False
    Button_SCHREIBEN.Enabled = False
    Command_LM75.Enabled = False
    
    'Statusfelder weis
    Label_SDA.BackColor = vbWhite
    Label_SCL.BackColor = vbWhite
    Label_INT.BackColor = vbWhite
    
End If

Exit Sub      ' Vor Fehlerbehandlung beenden.

Fehlerbehandlung:
Select Case Err.Number   ' Fehlernummer auswerten.
   Case 380
        Fehler = MsgBox("Fehler im COM-Settings", vbCritical)
   Case 8002
        Fehler = MsgBox(Combo_ComPort.Text & " nicht vorhanden", vbCritical)
   Case Else
        Mldg = "Fehler # " & Str(Err.Number) & " wurde ausgelst von " _
              & Err.Source & Chr(13) & Err.Description
        Fehler = MsgBox(Mldg, vbCritical, "Fehler", Err.HelpFile, Err.HelpContext)
   End Select

End Sub

Private Sub Button_IDENT_Click()
'Befehl 16: IDENT
'Modem sendet I2C-OK. Dieser Befehl kann dazu verwendet
'werden, das I2C-Modem an der 'RS232 zu erkennen.
'Empfngt das I2C-Modem 'diesen Befehl,
'wird ein Datenbyte generiert,
'in dem die Bits 6 und 7 gesetzt sind. (192 dez)
'Antwort 192 = OK

Modem_Komm(1) = 16  'Befehl 16 = IDENT
I2C_SendKom (1)     'Kommando absetzen (1Byte)

End Sub

Private Sub Button_STATUS_Click()
'Befehl 48: STATUS
'liest er die Zustnde der Leitungen SDA, SCL und INT aus.
'Diese werden zusammen mit einem OK in einem Byte an den PC zurckgesendet.

Modem_Komm(1) = 48  'Befehl 48 = Statusabfrage
I2C_SendKom (1)     'Kommando absetzen (1Byte)


End Sub

Private Sub Button_VERSION_Click()
'Befehl 80: VERSION
'Das I2C-Modem antwortet mit zwei Byte.
'Werden die Bytes in der Reihenfolge zusammengesetzt
'so ergibt sich die Versionsnummer der geladenen Firmware

Modem_Komm(1) = 80  'Befehl 80 = Versionsabfrage
I2C_SendKom (1)     'Kommando absetzen (1Byte)

End Sub

Private Sub Button_SPEED_Click()
'Befehl 32: SPEED
'Die Busgeschwindigkeit des I2C-Busses wird auf den gewnschten Wert eingestellt.
'Der Defaultwert ist Null und stellt die maximale Busgeschwindigkeit ein.

' Folgende Werte sind mglich:
' 0 = 43 KHz,  1 = 28 KHz,  2 = 17 KHz,  3 = 9 KHz
' 4 = 5  KHz,  5 = 2,5 KHz, 6 = 1,3 KHz

' Beispiel: SENDBYTE (32 + 5) stellt den Bustakt auf 2,5 kHz ein
' Antwort 192 = OK

Dim W
W = (Combo_SPEED.ListIndex)
Modem_Komm(1) = 32 + W 'Befehl 32 + Wert
I2C_SendKom (1)        'Kommando absetzen (1Byte)

End Sub

Private Sub Button_SCHREIBEN_Click()
'Befehl 64: WRITE
'Mit dem Befehl werden 1-16 Bytes zum I2C-Bus geschrieben
On Error GoTo ErrorHandler             'Fr falsche Eingaben im Feld

Dim A, W
Dim Adr
Adr = Combo_AUSGABE_ADR.Text      'Adresse aus Combo-Box

If Text_AUSGABE_WERT.Text > 255 Then
    MsgBox ("Im Feld WERT nur Zahlen <= 255 erlaubt")
Else
    If Check_A_INVERS = 1 Then
      W = 255 - Text_AUSGABE_WERT.Text  'invertierten Ausgabewert zum Portbaustein schreiben
    Else
      W = Text_AUSGABE_WERT.Text        'Ausgabewert zum Portbaustein schreiben
    End If
    
    Modem_Komm(1) = 64          'Befehl 64 = Multiwrite + (Anzahl Bytes -1)
    Modem_Komm(2) = Adr         'Busadresse
    Modem_Komm(3) = W           'Wert
    I2C_SendKom (3)             'Kommando absetzen (2Byte)
    
End If
Exit Sub


ErrorHandler:
Select Case Err.Number          'Fehlernummer auswerten.
    Case 0 'ok
    Case 13
         MsgBox ("Im Feld WERT nur Zahlen erlaubt")
         Text_AUSGABE_WERT.Text = ""
    Case Else
        MsgBox ("Fehler " & Err.Number)
    End Select
    
End Sub

Private Sub Button_LESEN_Click()
'Befehl 128: READ
'Mit dem Befehl werden 1-16 Bytes vom I2C-Bus ausgelesen
Dim Adr
Adr = Combo_EINGABE_ADR.Text      'Adresse aus Combo-Box

Modem_Komm(1) = 128         'Befehl 128 = Multiread + (Anzahl Bytes -1)
Modem_Komm(2) = Adr         'Busadresse
I2C_SendKom (2)             'Kommando absetzen (2Byte)

End Sub

Private Sub Command_LM75_Click()
'Befehl 128: READ
'Mit dem Befehl werden 1-16 Bytes vom I2C-Bus ausgelesen
Dim Adr
Adr = Combo_LM75_ADR.Text   'Adresse LM75 aus Combo-Box
LM75 = True

Modem_Komm(1) = 129         'Befehl 128 = Multiread + (Anzahl Bytes -1)
Modem_Komm(2) = Adr         'Busadresse
I2C_SendKom (2)             'Kommando absetzen (2Byte)

End Sub


Private Sub I2C_SendKom(AnzBy)
'Der befehl sendet die eingetragenen Kommandos zum Modem
' In der Klammer wird die Anzahl der Bytes eingetragen
Dim I, out$, SText$

For I = 1 To AnzBy
    out$ = out$ & Chr$(Modem_Komm(I))
    SText$ = SText$ & Str$(Modem_Komm(I)) & " "
Next

'Befehl ber MS-Comm-Control absetzen
MSComm1.Output = out$ '& Chr$(13)

'Timer starten fr Antwort
Timer1.Enabled = True

End Sub

Private Sub Label_HORTER_DE_Click()

URLGoTo Me.hwnd, "http://www.horter.de"

End Sub

Private Sub MSComm1_OnComm()
'Ein OnComm-Ereignis wird immer dann ausgelst, wenn sich der Wert
'einer CommEvent-Eigenschaft ndert. Eine solche nderung zeigt an,
'da entweder ein Kommunikationsereignis
'oder ein Fehler aufgetreten ist.

Select Case MSComm1.CommEvent
    Case comEvCTS   ' Pegelnderung auf CTS
    'Der Zustand des CTS-Signals (Clear to Send)
    'hat sich gendert. Beim I2C-Modem ist
    'dies der INT einer angeschlossenen Eingabekarte

    'Abfrage ob die CTS-leitung high oder low ist
    If MSComm1.CTSHolding = True Then
      Label_AUTO_INT.BackColor = vbRed
    Else
      Label_AUTO_INT.BackColor = vbWhite
    End If

End Select

End Sub

Private Sub Timer1_Timer()
'Antwort vom I2C-Modem lesen
Dim I, Z, AnzBy, Empf$
Dim bArray() As Byte

'Timer stoppen
Timer1.Enabled = False

'Anzeigen wie viele Bytes im Eingangspuffer stehen
AnzBy = MSComm1.InBufferCount - 1
Label_STATUS_BYTES.Caption = AnzBy & " Byte empfangen"

'Eingangspuffer komplett lesen
If MSComm1.PortOpen = True Then
  bArray() = MSComm1.Input
  
  'Werte aus Array umkopieren
  For I = 0 To AnzBy
    Modem_Antw(I + 1) = bArray(I)
  Next I

End If

Call Antwort

End Sub

Private Sub Antwort()
' Hier werden die Antworten vom Modem ausgewertet
Dim F   'Fehler

'Auswertung abhngig vom letzten Befehl
Select Case Modem_Komm(1)
    Case 16                 'IDENT
    If Modem_Antw(1) = 192 Then
        Label_IDENT.Caption = "ok"
        Label_IDENT.BackColor = hgn  'hellgrn
    Else
         Label_IDENT.Caption = "Fehler"
         Label_IDENT.BackColor = hrt 'hellrot
    End If
    
    Case 48                 'STATUS
        If (Modem_Antw(1) And 1) > 0 Then
            Label_SDA.BackColor = vbGreen
        Else
            Label_SDA.BackColor = vbWhite
        End If

        If (Modem_Antw(1) And 2) > 0 Then
            Label_SCL.BackColor = vbYellow
        Else
            Label_SCL.BackColor = vbWhite
        End If

        If (Modem_Antw(1) And 4) > 0 Then
            Label_INT.BackColor = vbWhite
        Else
            Label_INT.BackColor = vbRed
        End If
    
    
    Case 80                  'VERSION
    Label_VERSION.Caption = Modem_Antw(1) & "." & Modem_Antw(2)
   
    
    Case 32 To 38            'SPEED
        If Modem_Antw(1) = 192 Then
            MsgBox ("Speed auf " & Combo_SPEED.Text & " eingestellt")
        Else
            F = MsgBox("Fehler bei SPEED", vbCritical)
        End If
        
        
    Case 64 To 79 'Befehl 64..79: WRITE bis zu 16 Bytes
        Call STATUS   'Status bernehmen


    Case 128 To 143 'Befehl 128..143: READ bis zu 16 Bytes
        F = STATUS  'Status bernehmen
        If LM75 = True Then
            LM75 = False
            'Temperatur eintragen
            If F = False Then
                Call LM75_TEMPERATUR(Modem_Antw(2), Modem_Antw(3))
            Else
                Call LM75_TEMPERATUR(0, 0)
            End If
        Else
            If F = False Then
              'gelesener Wert eintragen der Eingabekarte
              If Check_E_INVERS = 0 Then
                Text_EINGABE_WERT = Modem_Antw(2)
              Else
                Text_EINGABE_WERT = 255 - Modem_Antw(2)
              End If
            Else
              Text_EINGABE_WERT = 0
            End If
        End If
        
    End Select

End Sub

Private Function STATUS()
    Dim Fehler As Boolean
    Dim V

    'Farbumschlag fr Fehlernummer
    Fehler = Not Modem_Antw(1) And 128
    If Fehler Then
        Label_STATUS_MODEM.BackColor = hrt 'hellrot
    Else
        Label_STATUS_MODEM.BackColor = hgn 'hellgrn
    End If

    'Statusbyte in Feld kopieren
    Label_STATUS_MODEM.Caption = Modem_Antw(1)

    'Statusbits rangieren
    Check_STATUS(0).Value = BoolToInt(Modem_Antw(1) And 1)
    Check_STATUS(1).Value = BoolToInt(Modem_Antw(1) And 2)
    Check_STATUS(2).Value = BoolToInt(Modem_Antw(1) And 4)
    Check_STATUS(3).Value = BoolToInt(Modem_Antw(1) And 8)
    Check_STATUS(4).Value = BoolToInt(Modem_Antw(1) And 16)
    Check_STATUS(5).Value = BoolToInt(Modem_Antw(1) And 32)
    Check_STATUS(6).Value = BoolToInt(Modem_Antw(1) And 64 And Fehler)

    STATUS = Fehler
End Function

Private Sub LM75_TEMPERATUR(ByVal BY1 As Byte, ByVal BY2 As Byte)
    Dim Wert

    If (BY1 And 128) = False Then
        Wert = BY1        'Temperatur Vorkomma >= 0C
    Else
        Wert = BY1 - 255  'Temperatur Vorkomma < 0C
    End If

    If BY2 And 128 Then
        Wert = Wert + 0.5
    End If

    Text_LM75.Text = Format(Wert, "##,##0.00 C")

End Sub

Private Function BoolToInt(B As Boolean)
'Gibt 1 zurck wenn B=TRUE
'GOBT 0 zurck wenn B=FALSE

If B = True Then
    BoolToInt = 1
Else
    BoolToInt = 0
End If


End Function

Private Sub URLGoTo(ByVal hwnd As Long, ByVal URL As String)
  Screen.MousePointer = 11
  Call ShellExecute(hwnd, "Open", URL, "", "", 3)
  Screen.MousePointer = 0
End Sub
