package i2cserial::cctools;

#Defines for cctools Serial Interface
#http://cctools.hs-control.de/ext_index.php?artikel=1201
#Perl by (C) Thomas Dreler 2006
use strict;
use warnings;
use Time::HiRes qw( usleep ualarm);
use lib "../.";
use i2cserial::log qw(&debug_log &error_txt $debug);
use constant False=>0;
use constant True=>1;
use constant lf=>"\n";

    BEGIN {
        use Exporter   ();
        our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

        # set the version for version checking
        $VERSION     = 0.01;
        # if using RCS/CVS, this may be preferred
        #$VERSION = sprintf "%d.%03d", q$Revision: 1.1 $ =~ /(\d+)/g;

        @ISA         = qw(Exporter);
        @EXPORT      = qw(&DeviceOpen &DeviceClose  &DeviceCheck &SDA
        		&SCL &GetSDA &GetSCL &GetINT);
        %EXPORT_TAGS = ( );     # eg: TAG => [ qw!name1 name2! ],

        # your exported package globals go here,
        # as well as any optionally exported functions
        @EXPORT_OK   = qw(&DTR &RTS &DSR &CTS &opencom &closecom);
            } our @EXPORT_OK;

    # exported package globals go here
    


    # non-exported package globals go here
    our $PortState;
    our $SCLState;
    our $PortObj;
    our $Port;
				
    # initialize package globals, first exported ones
		

    # then the others (which are still accessible as $Some::Module::stuff)
    $PortState=False;
    $SCLState=False;
    $PortObj=undef;
    $Port='COM1';

    

    # all file-scoped lexicals must be created before
    # the functions below that use them.

    # file-private lexicals go here
    

    # here's a file-private function as a closure,
    # callable as &$priv_func;  it cannot be prototyped.
    
    # make all your functions, whether exported or not;
    # remember to put something interesting in the {} stubs
    #sub func1      {}    # no prototype
    #sub func2()    {}    # proto'd void
    #sub func3($$)  {}    # proto'd to 2 scalars
        # this one isn't exported, but could be called!
    #sub func4(\%)  {}    # proto'd to 1 hash ref
		

#------------- Serial Port functions -----------------------------

sub opencom{
	my $PortName=shift;
	my $error=True;
	my $quiet=$debug;
	my $OS=$^O;
	if ($OS eq 'MSWin32') {
		eval ("use Win32::SerialPort qw { :PARAM :STAT };");
		die "$@\n" if ($@);
		$PortObj = new Win32::SerialPort ($PortName, $quiet)
	       || warn "Can't open $PortName: $^E\n";    # $quiet is optional
	} else {
		eval ("use Device::SerialPort qw { :PARAM :STAT };");
		die "$@\n" if ($@);
		$PortObj = new Device::SerialPort ($PortName, $quiet)
		|| warn "Can't open $PortName: $^E\n";    # $quiet is optional
        
	}
	$PortObj->databits(8);
	$PortObj->baudrate(1200);
	$PortObj->parity("none");
	$PortObj->stopbits(1);
	$PortObj->handshake("none");
	$PortObj->read_char_time(1);
	$PortObj->datatype('raw');        # in case an application needs_to_know
	$PortObj->binary(1);
	# 1 second per unfulfilled "read" call
	$PortObj->read_const_time(5); 
	if (! $PortObj->write_settings) {
		undef $PortObj;
		warn "Write Settings failed!\n";
	} else {
		$error=False;
		$PortState=True;
	}
	return ! $error;

}
sub closecom {
    if (defined($PortObj)) {
			$PortObj->close;
			$PortObj=undef;
    }
    $PortState=False;
}

sub RTS {
	my $i=shift;
	if ($i) {
		$PortObj->rts_active('T');
	}else { 
		$PortObj->rts_active(0);
	}
}
 
sub DTR {
    my $i=shift;
    if ($i) {
	$PortObj->dtr_active('T');
    }else { 
	$PortObj->dtr_active(0);
    }
}
sub DSR {
#(MS_CTS_ON       MS_DSR_ON       MS_RING_ON      MS_RLSD_ON)
    my $ModemStatus = $PortObj->modemlines;
    my $r=(($ModemStatus & $PortObj->MS_DSR_ON)==$PortObj->MS_DSR_ON);
    return $r;
}

sub CTS {
    #(MS_CTS_ON       MS_DSR_ON       MS_RING_ON      MS_RLSD_ON)
    my $ModemStatus = $PortObj->modemlines;
    my $r=(($ModemStatus & $PortObj->MS_CTS_ON)==$PortObj->MS_DSR_ON);
    return $r;
}

#-------------- I2C Functions ------------------



sub SCL {
#SCL is assigned to DTR-Line on COMx
	my $i=shift;
	DTR($i);	
	$SCLState=$i;
}
sub SDA {
#SDA is assigned to RTS-Line on COMx
	my $i=shift;
	RTS($i);
}

sub GetSDA {
#SDA will be read out on CTS-Line of COMx
	my $r=CTS;
	return $r;
}
sub GetINT {
#not implemented
	return False;
}
sub GetSCL{
#this value is faked;the last noticed output will be returned
return $SCLState;
}

#check, if Device available
sub DeviceCheck {
#not implemented
	return True;
}

#open Interface
sub DeviceOpen {
	my $p=shift;
	$p=$Port if (!$p);
	debug_log( "I2COpen $p".lf);
	my $error=False;
	if (!opencom($port)){
		debug_log ("Cannot open $p".lf);
		error_txt ("Cannot open $p".lf);
		$error=True;
		return !$error;
	}
	#Check Device
	my $r=DeviceCheck;
        #save successfully opened port
        $Port=$p if ($r);
	return $r;
	
}
#Interface close
sub DeviceClose {
	
	debug_log("I2CClose".lf);
	closecom;
}


    END {DeviceClose;}       # module clean-up code here (global destructor)    

1;