package i2cserial::lm75;

use lib "../.";
use strict;
use i2cserial::base qw(:DEFAULT $i2c_error);
use i2cserial::log qw(:DEFAULT $errorstr);
BEGIN {
        use Exporter   ();
        our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);

        # set the version for version checking
        $VERSION     = 0.01;
        # if using RCS/CVS, this may be preferred
        #$VERSION = sprintf "%d.%03d", q$Revision: 1.1 $ =~ /(\d+)/g;

        @ISA         = qw(Exporter);
        @EXPORT      = qw(&LM75_getTemp &LM75_getHyst &LM75_getSP &LM75_getConf
  			&LM75_setHyst &LM75_setSP &LM75_setConf);
        %EXPORT_TAGS = ();     # eg: TAG => [ qw!name1 name2! ],

        # your exported package globals go here,
        # as well as any optionally exported functions
        @EXPORT_OK   = ();
            }   our @EXPORT_OK;

    # exported package globals go here
    

    # non-exported package globals go here
    
    # initialize package globals, first exported ones
    
    # then the others (which are still accessible as $Some::Module::stuff)
    

    # all file-scoped lexicals must be created before
    # the functions below that use them.

    # file-private lexicals go here
    

    # here's a file-private function as a closure,
    # callable as &$priv_func;  it cannot be prototyped.
    
    # make all your functions, whether exported or not;
    # remember to put something interesting in the {} stubs
    #sub func1      {}    # no prototype
    #sub func2()    {}    # proto'd void
    #sub func3($$)  {}    # proto'd to 2 scalars
        # this one isn't exported, but could be called!
    #sub func4(\%)  {}    # proto'd to 1 hash ref



		END { }       # module clean-up code here (global destructor)
		
#LM75 operations
#Register=0 Temperatur
#Register=1 Konfiguration
#Register=2 Schaltpunkt
#Register=3 Hysterese

#Registers
use constant LM75_Temp=>0;
use constant LM75_Conf=>0;
use constant LM75_SP=>2;
use constant LM75_Hyst=>3;

#general
use constant lf=>"\n";

sub i2cLM75_in { 
#Liest einen Wert (2 Byte) vom LM75 Temperatursensor
    my $Wert=0;
    my $str="+0.0";
    debug_log("i2cLM75In".lf); 
    my $Byte1 = i2cIn;                 #1. Byte Wert vom LM75 lesen
    i2cAck;
    my $Byte2 = i2cIn;                 #2. Byte lesen
    i2cNoAck;
        
    if (($Byte1 & 128) == 0) {
        $Wert = $Byte1;              #Temperatur Vorkomma >= 0C
    }else{
        $Wert = $Byte1 - 255;        #Temperatur Vorkomma < 0C
    }
      
    if (($Byte2 & 128) != 0) {
        $Wert = $Wert + 0.5;
        $str="+0.5";
    }
    debug_log( "IN Byte1=$Byte1,Byte2=$str -->Wert $Wert;".lf);
    return $Wert;

}

sub i2cLM75_out {
    my $wert=shift;
#Schreibt einen Wert (2 Byte) vom LM75 Temperatursensor

   my $VK = floor($wert);
   my $NK = $wert- $VK;

    if ($VK >= 0) {
        i2cOut ($VK);
    }else {
        i2cOut (255 + $VK);
    }

    if ($NK >= 0.5) {      #Nachkommawert schreiben
        i2cOut (128);      # xx,5 schreiben
    }else{
        i2cOut (0);        # xx,0 schreiben
    }

}

sub i2cLM75read {
    my ($Adresse,$register)=@_;
    my $temp;
#Werte vom LM75 lesen
    i2cInit;
    i2cStart;
    if (i2cSlave($Adresse)){
  		i2cOut ($register); #Register auf Temperatur setzen
  		i2cStop();
  		i2cStart();
  		i2cSlave ($Adresse + 1); #Bus-Adresse des LM75 schreiben
			$temp = i2cLM75_in; #Temperatur auslesen
			debug_log("Register:".$register."->".sprintf ("%4.2f",$temp).lf);
			i2cAck;
    } else {
    	i2cNoAck;
    }
    i2cStop;
    return $temp;
}

sub LM75_getTemp{
    my $adresse=shift;
	#Hysterese vom LM75 lesen
    my $temp = i2cLM75read($adresse,LM75_Temp); #Temperatur auslesen
    if ($i2c_error){
    	debug_log ("Error: $errorstr". lf);
    } else {
    	debug_log ("Temperatur :".sprintf("%4.2f",$temp). lf);
    	return $temp;
    }
}

sub LM75_getHyst{
    my $adresse=shift;
	#Hysterese vom LM75 lesen
    my $temp = i2cLM75read($adresse,LM75_Hyst); #Hysterese auslesen
    if ($i2c_error){
    	debug_log ("Error: $errorstr". lf);
    } else {
    	debug_log ("Hysterese :".sprintf("%4.2f",$temp). lf);
    	return $temp;
    }
}
sub LM75_getSP{
    my $adresse=shift;
	#Hysterese vom LM75 lesen
    my $temp = i2cLM75read($adresse,LM75_SP); #Schaltpunkt auslesen
    if ($i2c_error){
    	debug_log ("Error: $errorstr". lf);
    } else {
    	debug_log ("SwitchPoint :".sprintf("%4.2f",$temp). lf);
    	return $temp;
    }
}

sub LM75write {
    my($adresse,$register,$value)=@_;
#LM75 Parameter setzen
    i2cInit;
    i2cStart;
    if (i2cSlave($adresse)) {
        i2cOut ($register);  
        i2cLM75_out ($value);
    }
    i2cStop;
}

sub LM75_setHyst {
    my ($adresse,$value)=@_;
    my $register=LM75_Hyst;
    #Hysterese am LM75 setzen
    LM75write($adresse,$register,$value);
}

sub LM75_setSP {
    my ($adresse,$value)=@_;
    my $register=LM75_SP;
    #Hysterese am LM75 setzen
    i2cLM75write($adresse,$register,$value);
}

sub LM75_setConf {
    my ($adresse,$config)=@_;
    my $register=LM75_Conf;
    #Konfiguration vom LM75 setzen
    i2cLM75write($adresse,$register,$config);
}


sub LM75_getConf {
    my $adresse=shift;
    my $config=undef;
#Konfiguration vom LM75 lesen
    i2cInit();
    i2cStart();
    if (i2cSlave($adresse)) {
        i2cOut (LM75_Conf);       #Register auf "Config" setzen
        i2cStop;
        i2cStart;
        i2cSlave ($adresse + 1); #Bus-Adresse des LM75 schreiben
        $config = i2cIn;         #Konfigurationsbyte lesen
    }
    i2cAck();
    i2cStop();
    return $config;
}
1;

