; PureBasic Visual Designer v3.90 build 1361

; Deklaration der Variablen
Global com_status.b, Port.s, Handshake.l, Buffer.l, HCom.l
Global sda_status.b, scl_status.b

; Einbinden dr Include-Dateien
IncludeFile "RS232_I2C_Window.pb"

; Definiton der Proceduren
Procedure.l WindowCallBack(WindowId.l, Message.l, wParam.l, lParam.l)
  ReturnValue = #PB_ProcessPureBasicEvents 
  ReturnValue = PureCOLOR_CallBack(WindowId, Message, wParam, lParam, ReturnValue)
  ProcedureReturn ReturnValue 
EndProcedure


Procedure Test_COM_Ports()
      anzahl = 0      
      Handshake = 0
      Buffer = 1024
      For i = 1 To 9
            Port = "com"+ Str(i) + ":" + GetGadgetText(#BAUTRATE) + ",n,8,1"
            HCom = ComOpen(Port, Handshake,Buffer,Buffer)
            If HCom > 0
                  AddGadgetItem(#COM_PORT, -1,"com" + Str(i))
                  ComClose(HCom)
                  anzahl = anzahl + 1
            EndIf
      Next i
      SetGadgetState(#COM_PORT,0)           ; Default Port ist der erste Eintrag in der Liste     
      If anzahl = 0
           MessageRequester("W A R N U N G", "Es wurde keine RS232 gefunden",0) 
      EndIf
EndProcedure




Procedure Handle_RS232()
       If com_status = 0
            SetGadgetText(#COM_OPEN,"schliessen")
            com_status = 1
            Port = GetGadgetText(#COM_PORT)+ ":" + GetGadgetText(#BAUTRATE) + ",n,8,1"
            Handshake = 0
            Buffer = 1024
            HCom = ComOpen(Port, Handshake,Buffer,Buffer)
            If HCom > 0
                 ComSetDTR(HCom,1)
                 ComSetRTS(HCom,1)
                 SetGadgetText(#SDA_SET_SHOW, "1")
                 PureCOLOR_SetGadgetColor(#SDA_SET_SHOW, RGB(0,0,0), RGB(0,255,0))
                 SetGadgetText(#SCL_SET_SHOW, "1")
                 PureCOLOR_SetGadgetColor(#SCL_SET_SHOW, RGB(0,0,0), RGB(255,255,128))
                 SetGadgetText(#SDA_GET_SHOW, "1")
                 PureCOLOR_SetGadgetColor(#SDA_GET_SHOW, RGB(0,0,0), RGB(0,255,0))
                 SetGadgetText(#INT_GET_SHOW, "0")
                 PureCOLOR_SetGadgetColor(#INT_GET_SHOW, RGB(0,0,0), RGB(255,255,255))
                 sda_status = 1
                 scl_status = 1
            Else
                  MessageRequester("F E H L E R", "COM-Port konnten nicht geffnet werden",0)
                  SetGadgetText(#COM_OPEN,"ffnen")
                  com_status = 0
            EndIf
       Else
             SetGadgetText(#COM_OPEN,"ffnen")
             ComClose(HCom)        ; Close the communication port
             HCom = -1
             com_status = 0
       EndIf
EndProcedure

Procedure Toggle_SDA() 
      If HCom > 0
            If sda_status = 0
                  SetGadgetText(#SDA_SET_SHOW, "1")
                  PureCOLOR_SetGadgetColor(#SDA_SET_SHOW, RGB(0,0,0), RGB(0,255,0))
                  ComSetDTR(HCom,1)
                  sda_status = 1
            Else
                  SetGadgetText(#SDA_SET_SHOW, "0")
                  PureCOLOR_SetGadgetColor(#SDA_SET_SHOW, RGB(0,0,0), RGB(255,255,255))
                  ComSetDTR(HCom,0)
                  sda_status = 0
            EndIf
       Else
            MessageRequester("F E H L E R   S D A", "COM-Port ist nicht geffnet",0)     
       EndIf
EndProcedure


Procedure Take_SDA()
      If HCom > 0
            If ComGetDSR(HCom)
                  SetGadgetText(#SDA_GET_SHOW, "1")
                  PureCOLOR_SetGadgetColor(#SDA_GET_SHOW, RGB(0,0,0), RGB(0,255,0))
            Else
                  SetGadgetText(#SDA_GET_SHOW, "0")
                  PureCOLOR_SetGadgetColor(#SDA_GET_SHOW, RGB(0,0,0), RGB(255,255,255))
            EndIf
      Else
            MessageRequester("F E H L E R    S D A", "COM-Port ist nicht geffnet",0)     
       EndIf
EndProcedure
 

Procedure Toggle_SCL() 
      If HCom > 0
            If scl_status = 0
                  PureCOLOR_SetGadgetColor(#SCL_SET_SHOW, RGB(0,0,0), RGB(255,255,128))
                  SetGadgetText(#SCL_SET_SHOW, "1")
                  ComSetRTS(HCom,1)
                  scl_status = 1
            Else
                  PureCOLOR_SetGadgetColor(#SCL_SET_SHOW, RGB(0,0,0), RGB(255,255,255))
                  SetGadgetText(#SCL_SET_SHOW, "0")
                  ComSetRTS(HCom,0)
                  scl_status = 0
            EndIf
       Else
            MessageRequester("F E H L E R   S C L ", "COM-Port ist nicht geffnet",0)     
       EndIf
EndProcedure

Procedure Take_INT()
      If HCom > 0
            If ComGetCTS(HCom)
                  SetGadgetText(#INT_GET_SHOW, "1")
                  PureCOLOR_SetGadgetColor(#INT_GET_SHOW, RGB(0,0,0), RGB(255,0,0))
            Else
                  SetGadgetText(#INT_GET_SHOW, "0")
                  PureCOLOR_SetGadgetColor(#INT_GET_SHOW, RGB(0,0,0), RGB(255,255,255))

            EndIf
      Else
            MessageRequester("F E H L E R    I N T", "COM-Port ist nicht geffnet",0)     
       EndIf
EndProcedure


; Hier beginnt das Hauptprogramm
com_status = 0  ; RS232 ist ausgeschaltet
sda_status = 0  ; SDA ist ausgeschaltet
scl_status = 0  ; SCL ist ausgeschaltet

Open_RS232_I2C_KOPPLER()  ; WINDOW aufbauen
SetWindowCallback(@WindowCallBack()) 
; Listeneintrge fr Bautrate 
      AddGadgetItem(#BAUTRATE, -1,"75")  ; hier wird die Liste generiert,
      AddGadgetItem(#BAUTRATE, -1,"150")  ; aus der der Nutzer eine Bautrate 
      AddGadgetItem(#BAUTRATE, -1,"300")  ; auswhlen kann
      AddGadgetItem(#BAUTRATE, -1,"600")
      AddGadgetItem(#BAUTRATE, -1,"1200")
      AddGadgetItem(#BAUTRATE, -1,"2400")
      AddGadgetItem(#BAUTRATE, -1,"4800")
      AddGadgetItem(#BAUTRATE, -1,"9600")
      AddGadgetItem(#BAUTRATE, -1,"19200")
      SetGadgetState(#BAUTRATE,7)            ; 9600 ist der DefaultWert
      
; Nun wurd es Farbig
      PureCOLOR_SetGadgetColor(#SDA_SET_SHOW, RGB(0,0,0), RGB(255,255,255))
      PureCOLOR_SetGadgetColor(#INT_GET_SHOW, RGB(0,0,0), RGB(255,255,255))
      PureCOLOR_SetGadgetColor(#SCL_SET_SHOW, RGB(0,0,0), RGB(255,255,255))
      PureCOLOR_SetGadgetColor(#SDA_GET_SHOW, RGB(0,0,0), RGB(255,255,255))
      PureCOLOR_SetGadgetColor(#COM_CONTROL_HEADLINE, RGB(0,0,0), RGB(168,176,200))
      PureCOLOR_SetGadgetColor(#I2C_CONTROL_HEADLINE, RGB(0,0,0), RGB(168,176,200)) 
      PureCOLOR_SetGadgetColor(#BAUTRATE_HEADLINE, RGB(0,0,0), RGB(168,176,200))
      PureCOLOR_SetGadgetColor(#COM_PORT_HEADLINE, RGB(0,0,0), RGB(168,176,200))     

; Jetzt noch die Beschreibung einfgen
      AddGadgetItem(#Editor_1,0,"1. COM ffnen")
      AddGadgetItem(#Editor_1,1,"2. Die Signale SCL und SDA lassen sich einzeln schalten. Die LEDs am Koppler mssen dem Signal folgen")
      AddGadgetItem(#Editor_1,2,"3. Mit dem Knopf SDA ? kann der Signalzustand dann wieder zurckgelesen werden.")
      AddGadgetItem(#Editor_1,3,"4. SDA auf 1 stellen und an einem Slave nach Masse ziehen - SDA ? drcken - Signal muss 0 sein.")
      AddGadgetItem(#Editor_1,4,"5. INT-Signal auf Masse zeihen -  INT ? drcken - Signal muss 1 sein ansonsten 0.")
      AddGadgetItem(#Editor_1,5,"")
      AddGadgetItem(#Editor_1,6,"Viel Spass beim Testen")


; Nachsehen welche Schnittstellen sind denn da?
      Test_COM_Ports()  
      
Repeat
      EventID = WaitWindowEvent()
      Select EventID 
            Case #PB_Event_Gadget
                  Select EventGadgetID()
                        Case #COM_OPEN
                              Handle_RS232()
                        Case #SDA_SET
                              Toggle_SDA()
                        Case #SDA_GET
                              Take_SDA() 
                        Case #SCL_SET
                              Toggle_SCL()
                        Case #INT_GET
                              Take_INT()  
                  EndSelect
      EndSelect
                       
Until EventID = #PB_Event_CloseWindow 


; ExecutableFormat=
; UseIcon=D:\ICON\RS232I2C.ico
; Executable=D:\Basic\Projekte\I2C_RS232_Tester\rs232i2c.exe
; EOF